using System;
using System.ComponentModel;
using System.Collections;
using Borland.Eco.Services;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.ObjectImplementation;
using Borland.Eco.Subscription;
using Borland.Eco.UmlRt;
using Borland.Eco.UmlCodeAttributes;


namespace Ecoyee
{
    [UmlElement("Package", Id="f722316d-0424-4eda-a18d-c7adbc5a19e6")]
	[UmlMetaAttribute("ownedElement", typeof(Country))]
	[UmlMetaAttribute("ownedElement", typeof(Customer))]
	[UmlMetaAttribute("ownedElement", typeof(Department))]
	[UmlMetaAttribute("ownedElement", typeof(Employee))]
	[UmlMetaAttribute("ownedElement", typeof(Job))]
	[UmlMetaAttribute("ownedElement", typeof(Project))]
	[UmlMetaAttribute("ownedElement", typeof(Sales))]
	[UmlMetaAttribute("ownedElement", typeof(SalaryHistory))]
	[UmlMetaAttribute("ownedElement", typeof(ProjectDepartmentBudget))]
	[EcoCodeGenVersion("2.0")]
	public abstract class CoreClassesPackage
	{
        
        [UmlElement("Association", Id="5d574c3d-b365-411c-95de-67f5a19ab599")]
		public class CustomerCountry
		{
		}
        
        [UmlElement("Association", Id="0d56b3b7-df0a-4f77-bd08-d9ef482ab047")]
		public class HeadSubDepartment
		{
		}
        
        [UmlElement("Association", Id="2f069c9d-5d45-41b6-bd87-57358fe9e628")]
		public class ManagerAssoc
		{
		}
        
        [UmlElement("Association", Id="6f009198-2970-49a1-ba86-b19e69f66a6b")]
		public class A1
		{
		}
        
        [UmlElement("Association", Id="bc58903b-b262-4b26-99c0-ab282df14ef1")]
		public class A2
		{
		}
        
        [UmlElement("Association", Id="11a8550a-a2c1-4676-9fc5-fd99e5aa1b77")]
		public class TeamLeader
		{
		}
        
        [UmlElement("Association", Id="ecc13ea5-ff46-4a11-be9e-dd9077376d31")]
		public class Employee_Project
		{
		}
        
        [UmlElement("Association", Id="bad97ffc-f23f-446d-9b29-0c818654bb6e")]
		public class A3
		{
		}
        
        [UmlElement("Association", Id="8be521c2-339f-4cc6-b2b5-834eda725483")]
		public class A4
		{
		}
        
        [UmlElement("Association", Id="bdab1a43-3230-45ae-8466-19de94623f14")]
		public class A5
		{
		}
        
        [UmlElement("Association", Id="46a5f9f8-6f32-48dd-9311-5a201ca55278")]
		public class A6
		{
		}
        
        [UmlElement("Association", Id="d1504453-5e2d-43ec-a47c-852f580132b1")]
		public class A7
		{
		}
        
        [UmlElement("Association", Id="225b2f14-5c51-4bae-a2f6-54c4808e5ea1")]
		public class A8
		{
		}
	}
    [UmlElement(Id="4802de60-753e-46e1-8efd-94e99a7b040c")]
    public class Country : ILoopBack {
        
        public class CountryListAdapter : ObjectListAdapter, ICountryList
		{
			public CountryListAdapter(IList source) : 
					base(source)
			{
			}
			public Country this[int index]
			{
				get
				{
					return ((Country)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Country value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Country value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Country value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Country value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Country value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        #region Autogenerated ECO code
        
        #endregion Autogenerated ECO code
        
        
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public Country(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 4);
			public const int Currency = Eco_FirstMember;
			public const int Name = (Currency + 1);
			public const int Job = (Name + 1);
			public const int Customer = (Job + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public Country(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="79223690-94d2-41d9-8c96-b6fce3b8c0e5", Index=Eco_LoopbackIndices.Name)]
		[UmlTaggedValue("Eco.Length", "15")]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
		[UmlElement(Id="69bd3657-6b41-406d-ab88-cdbe9452460c", Index=Eco_LoopbackIndices.Currency)]
		[UmlTaggedValue("Eco.Length", "10")]
		public string Currency
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Currency)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Currency, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Customer, Id="a9766a6a-2603-49a8-b9e5-148b79e9aa78")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.CustomerCountry), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public ICustomerList Customer
		{
			get
			{
				return new Customer.CustomerListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Customer))));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Job, Id="89923f23-64b0-4fb9-aeb1-8fd909182c19")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A2), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IJobList Job
		{
			get
			{
				return new Job.JobListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Job))));
			}
		}
    }

	[UmlCollection(typeof(Country))]
	public interface ICountryList : ICollection
	{
		#region ECO generated code
		Country this[int index]
		{
			get;
			set;
		}
		int Add(Country value);
		bool Contains(Country value);
		int IndexOf(Country value);
		void Insert(int index, Country value);
		void Remove(Country value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="00b9e638-23a9-4f4e-b6d5-2cc9984c21c5")]
    public class Customer : ILoopBack {
        
        public class CustomerListAdapter : ObjectListAdapter, ICustomerList
		{
			public CustomerListAdapter(IList source) : 
					base(source)
			{
			}
			public Customer this[int index]
			{
				get
				{
					return ((Customer)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Customer value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Customer value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Customer value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Customer value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Customer value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public Customer(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 13);
			public const int Address_Line2 = Eco_FirstMember;
			public const int Phone = (Address_Line2 + 1);
			public const int Name = (Phone + 1);
			public const int CustomerNumber = (Name + 1);
			public const int PostalCode = (CustomerNumber + 1);
			public const int City = (PostalCode + 1);
			public const int Contact_LastName = (City + 1);
			public const int Contact_FirstName = (Contact_LastName + 1);
			public const int Address_Line1 = (Contact_FirstName + 1);
			public const int OnHold = (Address_Line1 + 1);
			public const int State = (OnHold + 1);
			public const int Country = (State + 1);
			public const int Sales = (Country + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public Customer(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="42ea43af-f7f1-434e-8d94-cc70dd852c42", Index=Eco_LoopbackIndices.CustomerNumber)]
		[UmlTaggedValue("Eco.SaveAction", "DbAssign")]
		public int CustomerNumber
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CustomerNumber)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CustomerNumber, ((object)(value)));
			}
		}
		[UmlElement(Id="3d8d4202-3ebf-45fb-8288-e6d3a0b9261a", Index=Eco_LoopbackIndices.Name)]
		[UmlTaggedValue("Eco.Length", "25")]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
		[UmlElement(Id="b3c71d01-0e47-4793-9567-fd13edc9dad7", Index=Eco_LoopbackIndices.Contact_FirstName)]
		[UmlTaggedValue("Eco.Length", "15")]
		public string Contact_FirstName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Contact_FirstName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Contact_FirstName, ((object)(value)));
			}
		}
		[UmlElement(Id="a1a840d1-6331-4815-8f06-85e7065a8142", Index=Eco_LoopbackIndices.Contact_LastName)]
		[UmlTaggedValue("Eco.Length", "20")]
		public string Contact_LastName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Contact_LastName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Contact_LastName, ((object)(value)));
			}
		}
		[UmlElement(Id="285d7fad-8415-4289-ae38-c1671aa3c75f", Index=Eco_LoopbackIndices.Phone)]
		[UmlTaggedValue("Eco.Length", "20")]
		public string Phone
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Phone)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Phone, ((object)(value)));
			}
		}
		[UmlElement(Id="b4d3b5ec-9060-4cf6-8380-2328ebe61510", Index=Eco_LoopbackIndices.Address_Line1)]
		[UmlTaggedValue("Eco.Length", "30")]
		public string Address_Line1
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Address_Line1)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Address_Line1, ((object)(value)));
			}
		}
		[UmlElement(Id="1eff86d9-955f-4cea-84ed-3083b76a121f", Index=Eco_LoopbackIndices.Address_Line2)]
		[UmlTaggedValue("Eco.Length", "30")]
		public string Address_Line2
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Address_Line2)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Address_Line2, ((object)(value)));
			}
		}
		[UmlElement(Id="9c78ffd8-c41d-47b4-b8f1-963e2d0a0c35", Index=Eco_LoopbackIndices.City)]
		[UmlTaggedValue("Eco.Length", "25")]
		public string City
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.City)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.City, ((object)(value)));
			}
		}
		[UmlElement(Id="f267c84e-6c54-41d1-a831-18b556a6e3f6", Index=Eco_LoopbackIndices.State)]
		[UmlTaggedValue("Eco.Length", "15")]
		public string State
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.State)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.State, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Country, Id="93c1ecb1-0e35-43ae-93d3-19e459fff6e2")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.CustomerCountry), Index=1)]
		[UmlMetaAttribute("multiplicity", "1")]
		public Country Country
		{
			get
			{
				return ((Country)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Country)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Country, ((object)(value)));
			}
		}
		[UmlElement(Id="89d070bb-6f5c-4164-be31-6a755f9f0d50", Index=Eco_LoopbackIndices.PostalCode)]
		[UmlTaggedValue("Eco.Length", "12")]
		public string PostalCode
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.PostalCode)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.PostalCode, ((object)(value)));
			}
		}
		[UmlElement(Id="ec96f1ff-9f87-4e41-b99c-866cdcebd49f", Index=Eco_LoopbackIndices.OnHold)]
		public bool OnHold
		{
			get
			{
				return ((bool)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OnHold)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.OnHold, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Sales, Id="9cb17c08-8d5e-418d-b952-42ebffa2472c")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A4), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public ISalesList Sales
		{
			get
			{
				return new Sales.SalesListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Sales))));
			}
		}
    }

	[UmlCollection(typeof(Customer))]
	public interface ICustomerList : ICollection
	{
		#region ECO generated code
		Customer this[int index]
		{
			get;
			set;
		}
		int Add(Customer value);
		bool Contains(Customer value);
		int IndexOf(Customer value);
		void Insert(int index, Customer value);
		void Remove(Customer value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="23492959-774e-44cc-95de-8f4eabebf2ff")]
    public class Department : ILoopBack {
        
        public class DepartmentListAdapter : ObjectListAdapter, IDepartmentList
		{
			public DepartmentListAdapter(IList source) : 
					base(source)
			{
			}
			public Department this[int index]
			{
				get
				{
					return ((Department)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Department value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Department value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Department value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Department value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Department value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public Department(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 10);
			public const int Location = Eco_FirstMember;
			public const int Phone = (Location + 1);
			public const int DepartmentNumber = (Phone + 1);
			public const int Name = (DepartmentNumber + 1);
			public const int Budget = (Name + 1);
			public const int HeadDepartment = (Budget + 1);
			public const int SubDepartments = (HeadDepartment + 1);
			public const int Employee = (SubDepartments + 1);
			public const int Manager = (Employee + 1);
			public const int ProjectDepartmentBudget = (Manager + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public Department(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="7ab46cb4-b90f-415b-8c0c-21d61a6fb3c5", Index=Eco_LoopbackIndices.DepartmentNumber)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string DepartmentNumber
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.DepartmentNumber)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.DepartmentNumber, ((object)(value)));
			}
		}
		[UmlElement(Id="8b737152-b830-412b-8e3e-29220105d436", Index=Eco_LoopbackIndices.Name)]
		[UmlTaggedValue("Eco.Length", "25")]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.SubDepartments, Id="68bed122-fe0b-446f-97a3-6191c6e770d8")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.HeadSubDepartment), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IDepartmentList SubDepartments
		{
			get
			{
				return new Department.DepartmentListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.SubDepartments))));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.HeadDepartment, Id="227f42f0-fb61-4da2-bf6a-8101850fbd3c")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.HeadSubDepartment), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Department HeadDepartment
		{
			get
			{
				return ((Department)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.HeadDepartment)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.HeadDepartment, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Manager, Id="a199284b-b232-4aa7-b8c7-b55298f7840d")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.ManagerAssoc), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Employee Manager
		{
			get
			{
				return ((Employee)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Manager)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Manager, ((object)(value)));
			}
		}
		[UmlElement(Id="9024f318-a9cc-46f6-9ca4-f7bf611d7bd0", Index=Eco_LoopbackIndices.Budget)]
		[UmlMetaAttribute("initialValue", "50000")]
		public double Budget
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Budget)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Budget, ((object)(value)));
			}
		}
		[UmlElement(Id="537f0881-583f-4c01-a8cf-0ce15bbca0d3", Index=Eco_LoopbackIndices.Location)]
		[UmlTaggedValue("Eco.Length", "15")]
		public string Location
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Location)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Location, ((object)(value)));
			}
		}
		[UmlElement(Id="5ca9bb9b-89e0-4c65-a5dd-8f7bf825038b", Index=Eco_LoopbackIndices.Phone)]
		[UmlTaggedValue("Eco.Length", "20")]
		[UmlMetaAttribute("initialValue", "555-1234")]
		public string Phone
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Phone)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Phone, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Employee, Id="8c5989fa-5b4c-4904-9d8b-86d3369f8a3f")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A1), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IEmployeeList Employee
		{
			get
			{
				return new Employee.EmployeeListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Employee))));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.ProjectDepartmentBudget, Id="af8ab0ef-74bd-43a4-b632-9b6c0637192c")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A8), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IProjectDepartmentBudgetList ProjectDepartmentBudget
		{
			get
			{
				return new ProjectDepartmentBudget.ProjectDepartmentBudgetListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ProjectDepartmentBudget))));
			}
		}
    }

	[UmlCollection(typeof(Department))]
	public interface IDepartmentList : ICollection
	{
		#region ECO generated code
		Department this[int index]
		{
			get;
			set;
		}
		int Add(Department value);
		bool Contains(Department value);
		int IndexOf(Department value);
		void Insert(int index, Department value);
		void Remove(Department value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="3dd5171e-a58c-42b8-88b0-6dfcecc34fdc")]
    public class Employee : ILoopBack {
        
        public class EmployeeListAdapter : ObjectListAdapter, IEmployeeList
		{
			public EmployeeListAdapter(IList source) : 
					base(source)
			{
			}
			public Employee this[int index]
			{
				get
				{
					return ((Employee)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Employee value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Employee value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Employee value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Employee value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Employee value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public Employee(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 14);
			public const int FirstName = Eco_FirstMember;
			public const int PhoneExt = (FirstName + 1);
			public const int LastName = (PhoneExt + 1);
			public const int Salary = (LastName + 1);
			public const int EmployeeNumber = (Salary + 1);
			public const int HireDate = (EmployeeNumber + 1);
			public const int FullName = (HireDate + 1);
			public const int Project = (FullName + 1);
			public const int Sales = (Project + 1);
			public const int Job = (Sales + 1);
			public const int Department = (Job + 1);
			public const int LeadsProject = (Department + 1);
			public const int SalaryHistory = (LeadsProject + 1);
			public const int Manages = (SalaryHistory + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public Employee(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Manages, Id="db6ee9e5-f52a-4daa-8c84-234910e119f6")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.ManagerAssoc), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IDepartmentList Manages
		{
			get
			{
				return new Department.DepartmentListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Manages))));
			}
		}
		[UmlElement(Id="b1037755-5724-45d6-8af1-3c367a6932b0", Index=Eco_LoopbackIndices.EmployeeNumber)]
		[UmlTaggedValue("Eco.SaveAction", "DbAssign")]
		public short EmployeeNumber
		{
			get
			{
				return ((short)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.EmployeeNumber)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.EmployeeNumber, ((object)(value)));
			}
		}
		[UmlElement(Id="50cab8d3-51d6-430f-b4be-5558b897eab4", Index=Eco_LoopbackIndices.FirstName)]
		[UmlTaggedValue("Eco.Length", "15")]
		public string FirstName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.FirstName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.FirstName, ((object)(value)));
			}
		}
		[UmlElement(Id="87ae58ed-b9ad-46c1-95c0-151a951fc72b", Index=Eco_LoopbackIndices.LastName)]
		[UmlTaggedValue("Eco.Length", "20")]
		public string LastName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.LastName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.LastName, ((object)(value)));
			}
		}
		[UmlElement(Id="52f4ece7-30ec-477c-bc49-1a669d385663", Index=Eco_LoopbackIndices.PhoneExt)]
		[UmlTaggedValue("Eco.Length", "4")]
		public string PhoneExt
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.PhoneExt)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.PhoneExt, ((object)(value)));
			}
		}
		[UmlElement(Id="c59b9daa-1bc6-4fa0-98d7-aaf2ed81990b", Index=Eco_LoopbackIndices.HireDate)]
		public DateTime HireDate
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.HireDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.HireDate, ((object)(value)));
			}
		}
		[UmlElement(Id="90f288d9-c286-483f-bb43-cfcc1d7fa71e", Index=Eco_LoopbackIndices.Salary)]
		public double Salary
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Salary)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Salary, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Department, Id="8aefd8b3-2deb-4786-8342-8d4bbfeca32d")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A1), Index=1)]
		[UmlMetaAttribute("multiplicity", "1")]
		public Department Department
		{
			get
			{
				return ((Department)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Department)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Department, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.LeadsProject, Id="bda0c550-acc5-41c9-a5fc-534bdb877d07")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.TeamLeader), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IProjectList LeadsProject
		{
			get
			{
				return new Project.ProjectListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.LeadsProject))));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Project, Id="04b353ec-5b89-42f2-a349-01d39043d8e5")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.Employee_Project), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IProjectList Project
		{
			get
			{
				return new Project.ProjectListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Project))));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Job, Id="800c6055-4883-4ef1-8ac0-07541bc9041c")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A3), Index=1)]
		[UmlMetaAttribute("multiplicity", "1")]
		public Job Job
		{
			get
			{
				return ((Job)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Job)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Job, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Sales, Id="3a6f382d-35fa-46c9-96ca-1c8e49f7b6ad")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A5), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public ISalesList Sales
		{
			get
			{
				return new Sales.SalesListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Sales))));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.SalaryHistory, Id="d8f9acc0-89b6-4ea1-a6f7-e77d64501713")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A6), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public ISalaryHistoryList SalaryHistory
		{
			get
			{
				return new SalaryHistory.SalaryHistoryListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.SalaryHistory))));
			}
		}
		[UmlElement(Id="d6aa0ee6-046c-4dbb-a5b5-c5d96211b946", Index=Eco_LoopbackIndices.FullName)]
		[UmlTaggedValue("derived", "true")]
		[UmlTaggedValue("Eco.DerivationOCL", "FirstName +\' \' + LastName")]
		[UmlTaggedValue("persistence", "transient")]
		public string FullName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.FullName)));
			}
		}
    }

	[UmlCollection(typeof(Employee))]
	public interface IEmployeeList : ICollection
	{
		#region ECO generated code
		Employee this[int index]
		{
			get;
			set;
		}
		int Add(Employee value);
		bool Contains(Employee value);
		int IndexOf(Employee value);
		void Insert(int index, Employee value);
		void Remove(Employee value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="0dcd069a-2140-47be-b1eb-04c6c9c084fe")]
    public class Job : ILoopBack {
        
        public class JobListAdapter : ObjectListAdapter, IJobList
		{
			public JobListAdapter(IList source) : 
					base(source)
			{
			}
			public Job this[int index]
			{
				get
				{
					return ((Job)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Job value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Job value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Job value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Job value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Job value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public Job(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 8);
			public const int Requirement = Eco_FirstMember;
			public const int MinSalary = (Requirement + 1);
			public const int Title = (MinSalary + 1);
			public const int MaxSalary = (Title + 1);
			public const int Grade = (MaxSalary + 1);
			public const int Code = (Grade + 1);
			public const int Country = (Code + 1);
			public const int Employee = (Country + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public Job(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="e4f9e3af-0722-4775-a0c9-ce062d2c1b52", Index=Eco_LoopbackIndices.Code)]
		[UmlTaggedValue("Eco.Length", "5")]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Code
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Code)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Code, ((object)(value)));
			}
		}
		[UmlElement(Id="db0c4b6b-e5e5-4ea4-80f9-0fec70665d68", Index=Eco_LoopbackIndices.Grade)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public short Grade
		{
			get
			{
				return ((short)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Grade)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Grade, ((object)(value)));
			}
		}
		[UmlElement(Id="392522dc-59f4-4598-91cb-1f6e25d9796f", Index=Eco_LoopbackIndices.Title)]
		[UmlTaggedValue("Eco.Length", "25")]
		public string Title
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Title)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Title, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Country, Id="14b67fb6-e275-46f3-9cf5-517cbde830ba")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A2), Index=1)]
		[UmlMetaAttribute("multiplicity", "1")]
		public Country Country
		{
			get
			{
				return ((Country)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Country)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Country, ((object)(value)));
			}
		}
		[UmlElement(Id="36ed285b-b2b5-4a17-a51b-0032b53e5ee3", Index=Eco_LoopbackIndices.MinSalary)]
		public double MinSalary
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.MinSalary)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.MinSalary, ((object)(value)));
			}
		}
		[UmlElement(Id="890b77e6-9a73-4038-bba6-01c1e9814246", Index=Eco_LoopbackIndices.MaxSalary)]
		public double MaxSalary
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.MaxSalary)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.MaxSalary, ((object)(value)));
			}
		}
		[UmlElement(Id="3346f9f8-6cc4-464a-8448-a925e6808a79", Index=Eco_LoopbackIndices.Requirement)]
		public string Requirement
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Requirement)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Requirement, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Employee, Id="ad3a6858-adc3-4fc8-a798-9316c83aebc1")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A3), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IEmployeeList Employee
		{
			get
			{
				return new Employee.EmployeeListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Employee))));
			}
		}
    }

	[UmlCollection(typeof(Job))]
	public interface IJobList : ICollection
	{
		#region ECO generated code
		Job this[int index]
		{
			get;
			set;
		}
		int Add(Job value);
		bool Contains(Job value);
		int IndexOf(Job value);
		void Insert(int index, Job value);
		void Remove(Job value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="c9d655e7-4672-41bb-9a48-f84224dfdf11")]
    public class Project : ILoopBack {
        
        public class ProjectListAdapter : ObjectListAdapter, IProjectList
		{
			public ProjectListAdapter(IList source) : 
					base(source)
			{
			}
			public Project this[int index]
			{
				get
				{
					return ((Project)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Project value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Project value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Project value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Project value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Project value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public Project(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 7);
			public const int Name = Eco_FirstMember;
			public const int Product = (Name + 1);
			public const int Description = (Product + 1);
			public const int Id = (Description + 1);
			public const int TeamLeader = (Id + 1);
			public const int ProjectDepartmentBudget = (TeamLeader + 1);
			public const int Employee = (ProjectDepartmentBudget + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public Project(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="fe307824-48cd-4503-8c6a-78f92d0badfd", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.Length", "5")]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Id
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}
		[UmlElement(Id="83c0528e-70e0-4ca5-9780-c57089c300e7", Index=Eco_LoopbackIndices.Name)]
		[UmlTaggedValue("Eco.Length", "20")]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
		[UmlElement(Id="eb94b233-2acc-4f6c-8d89-f684ff7ba86f", Index=Eco_LoopbackIndices.Description)]
		[UmlMetaAttribute("initialValue", "software")]
		public string Description
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Description)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Description, ((object)(value)));
			}
		}
		[UmlElement(Id="9cf666d9-4d6b-46a7-98e5-681e1b6c4c69", Index=Eco_LoopbackIndices.Product)]
		[UmlMetaAttribute("initialValue", "software")]
		public string Product
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Product)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Product, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.TeamLeader, Id="2af26d61-358c-4064-b41b-6c8ba0b92822")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.TeamLeader), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Employee TeamLeader
		{
			get
			{
				return ((Employee)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.TeamLeader)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.TeamLeader, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Employee, Id="e86aca95-7a10-4d69-9341-3aeef18fbb94")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.Employee_Project), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IEmployeeList Employee
		{
			get
			{
				return new Employee.EmployeeListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Employee))));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.ProjectDepartmentBudget, Id="e0476db8-01cd-46c8-a720-01dc899fe4c7")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A7), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IProjectDepartmentBudgetList ProjectDepartmentBudget
		{
			get
			{
				return new ProjectDepartmentBudget.ProjectDepartmentBudgetListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ProjectDepartmentBudget))));
			}
		}
    }

	[UmlCollection(typeof(Project))]
	public interface IProjectList : ICollection
	{
		#region ECO generated code
		Project this[int index]
		{
			get;
			set;
		}
		int Add(Project value);
		bool Contains(Project value);
		int IndexOf(Project value);
		void Insert(int index, Project value);
		void Remove(Project value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="55be9d30-b82d-411c-bc31-87dc2ce457b2")]
    public class ProjectDepartmentBudget : ILoopBack {
        
        public class ProjectDepartmentBudgetListAdapter : ObjectListAdapter, IProjectDepartmentBudgetList
		{
			public ProjectDepartmentBudgetListAdapter(IList source) : 
					base(source)
			{
			}
			public ProjectDepartmentBudget this[int index]
			{
				get
				{
					return ((ProjectDepartmentBudget)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(ProjectDepartmentBudget value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(ProjectDepartmentBudget value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(ProjectDepartmentBudget value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, ProjectDepartmentBudget value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(ProjectDepartmentBudget value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public ProjectDepartmentBudget(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 4);
			public const int FiscalYear = Eco_FirstMember;
			public const int ProjectedBudget = (FiscalYear + 1);
			public const int Project = (ProjectedBudget + 1);
			public const int Department = (Project + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public ProjectDepartmentBudget(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="00c8c84f-bb90-4268-8378-64c832faf80c", Index=Eco_LoopbackIndices.FiscalYear)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public int FiscalYear
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.FiscalYear)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.FiscalYear, ((object)(value)));
			}
		}
		[UmlElement(Id="13808e56-9cd5-4366-ada0-9923d7d92b78", Index=Eco_LoopbackIndices.ProjectedBudget)]
		public double ProjectedBudget
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ProjectedBudget)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ProjectedBudget, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Project, Id="8217be45-8d1d-4e6b-aa58-bf8f33ba84a7")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A7), Index=1)]
		[UmlMetaAttribute("multiplicity", "1")]
		public Project Project
		{
			get
			{
				return ((Project)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Project)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Project, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Department, Id="a8bc29a4-9d24-4161-8162-c70d024e44fe")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A8), Index=0)]
		[UmlMetaAttribute("multiplicity", "1")]
		public Department Department
		{
			get
			{
				return ((Department)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Department)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Department, ((object)(value)));
			}
		}
    }
    [UmlElement(Id="bd5fbe77-3b16-4c05-88ca-5e3f4207b196")]
    public class Sales : ILoopBack {
        
        public class SalesListAdapter : ObjectListAdapter, ISalesList
		{
			public SalesListAdapter(IList source) : 
					base(source)
			{
			}
			public Sales this[int index]
			{
				get
				{
					return ((Sales)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Sales value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Sales value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Sales value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Sales value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Sales value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public Sales(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 13);
			public const int Discount = Eco_FirstMember;
			public const int ItemType = (Discount + 1);
			public const int PoNumber = (ItemType + 1);
			public const int OrderStatus = (PoNumber + 1);
			public const int OrderDate = (OrderStatus + 1);
			public const int TotalValue = (OrderDate + 1);
			public const int Aged = (TotalValue + 1);
			public const int DateNeeded = (Aged + 1);
			public const int QtyOrdered = (DateNeeded + 1);
			public const int Paid = (QtyOrdered + 1);
			public const int ShipDate = (Paid + 1);
			public const int SalesRep = (ShipDate + 1);
			public const int Customer = (SalesRep + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public Sales(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Customer, Id="b2efd396-eb6f-4751-b3f3-3564e1e8c114")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A4), Index=1)]
		[UmlMetaAttribute("multiplicity", "1")]
		public Customer Customer
		{
			get
			{
				return ((Customer)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Customer)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Customer, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.SalesRep, Id="82799106-55e1-4b29-9529-dca20ecdf42b")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A5), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Employee SalesRep
		{
			get
			{
				return ((Employee)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.SalesRep)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.SalesRep, ((object)(value)));
			}
		}
		[UmlElement(Id="3c8dabbc-fda3-4b6a-8e27-dd890ff531e5", Index=Eco_LoopbackIndices.PoNumber)]
		[UmlTaggedValue("Eco.Length", "8")]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string PoNumber
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.PoNumber)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.PoNumber, ((object)(value)));
			}
		}
		[UmlElement(Id="40b6eaaf-9835-475a-a8ce-df5974da51f1", Index=Eco_LoopbackIndices.OrderStatus)]
		[UmlMetaAttribute("initialValue", "new")]
		public string OrderStatus
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OrderStatus)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.OrderStatus, ((object)(value)));
			}
		}
		[UmlElement(Id="5a326c15-45a4-4a39-8ea0-9bdd2f06bd8e", Index=Eco_LoopbackIndices.OrderDate)]
		public DateTime OrderDate
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OrderDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.OrderDate, ((object)(value)));
			}
		}
		[UmlElement(Id="fce02a06-4384-47f5-a553-a4cfc4f06475", Index=Eco_LoopbackIndices.ShipDate)]
		public DateTime ShipDate
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipDate, ((object)(value)));
			}
		}
		[UmlElement(Id="8468d117-8c91-4775-a094-c2f44bfe1adb", Index=Eco_LoopbackIndices.DateNeeded)]
		public DateTime DateNeeded
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.DateNeeded)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.DateNeeded, ((object)(value)));
			}
		}
		[UmlElement(Id="cf6d4fe5-a6bc-40e8-9161-40d47ce210bf", Index=Eco_LoopbackIndices.Paid)]
		public bool Paid
		{
			get
			{
				return ((bool)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Paid)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Paid, ((object)(value)));
			}
		}
		[UmlElement(Id="c6b66646-0eb3-4e14-91f3-0fefc04e9777", Index=Eco_LoopbackIndices.QtyOrdered)]
		[UmlMetaAttribute("initialValue", "1")]
		public int QtyOrdered
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.QtyOrdered)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.QtyOrdered, ((object)(value)));
			}
		}
		[UmlElement(Id="1fd8cc5d-50aa-4dd5-98fb-48d845940267", Index=Eco_LoopbackIndices.Discount)]
		public float Discount
		{
			get
			{
				return ((float)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Discount)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Discount, ((object)(value)));
			}
		}
		[UmlElement(Id="337c8bf9-9620-4355-97e2-aea957f60928", Index=Eco_LoopbackIndices.ItemType)]
		public string ItemType
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ItemType)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ItemType, ((object)(value)));
			}
		}
		[UmlElement(Id="703a2056-d711-4451-bb05-f1c468c16bcc", Index=Eco_LoopbackIndices.Aged)]
		[UmlTaggedValue("derived", "True")]
		public int Aged
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Aged)));
			}
		}

		private void SubscribeToProp(string name, ISubscriber sub)
		{
		  int index = AsIObject().UmlClass.EcoClass.AllStructuralFeatures.GetItemByName(name).EcoStructuralFeature.IndexInAllStructuralFeatures;
		  IProperty p = AsIObject().Properties[index];
		  p.SubscribeToValue(sub);
		}

		[UmlElement]
		public int AgedDeriveAndSubscribe(ISubscriber subscriber1, ISubscriber subsciber2)
		{
			AsIObject().Properties["OrderDate"].SubscribeToValue(subscriber1);
			
			SubscribeToProp("OrderDate", subscriber1);
			SubscribeToProp("ShipDate", subscriber1);
			return ShipDate.Subtract(OrderDate).Days;
		}
		[UmlElement(Id="6fc09666-a3be-4367-b9ad-77637bd640bb", Index=Eco_LoopbackIndices.TotalValue)]
		public decimal TotalValue
		{
			get
			{
				return ((decimal)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.TotalValue)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.TotalValue, ((object)(value)));
			}
		}
    }

	[UmlCollection(typeof(Sales))]
	public interface ISalesList : ICollection
	{
		#region ECO generated code
		Sales this[int index]
		{
			get;
			set;
		}
		int Add(Sales value);
		bool Contains(Sales value);
		int IndexOf(Sales value);
		void Insert(int index, Sales value);
		void Remove(Sales value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="0da133f2-4d8f-4c20-8247-377b22260b5b")]
    public class SalaryHistory : ILoopBack {
        
        public class SalaryHistoryListAdapter : ObjectListAdapter, ISalaryHistoryList
		{
			public SalaryHistoryListAdapter(IList source) : 
					base(source)
			{
			}
			public SalaryHistory this[int index]
			{
				get
				{
					return ((SalaryHistory)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(SalaryHistory value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(SalaryHistory value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(SalaryHistory value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, SalaryHistory value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(SalaryHistory value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public SalaryHistory(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 6);
			public const int UpdaterId = Eco_FirstMember;
			public const int OldSalary = (UpdaterId + 1);
			public const int ChangeDate = (OldSalary + 1);
			public const int NewSalary = (ChangeDate + 1);
			public const int PercentChange = (NewSalary + 1);
			public const int Employee = (PercentChange + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public SalaryHistory(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Employee, Id="edba58cc-3ef9-4821-bfa4-7a48cbd5e5d6")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.A6), Index=1)]
		[UmlMetaAttribute("multiplicity", "1")]
		public Employee Employee
		{
			get
			{
				return ((Employee)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Employee)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Employee, ((object)(value)));
			}
		}
		[UmlElement(Id="8056f8ab-6183-4c30-9053-f778c1468134", Index=Eco_LoopbackIndices.ChangeDate)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public DateTime ChangeDate
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ChangeDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ChangeDate, ((object)(value)));
			}
		}
		[UmlElement(Id="1ee31d71-3d07-45e1-919f-978b2cc67fc0", Index=Eco_LoopbackIndices.UpdaterId)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string UpdaterId
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.UpdaterId)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.UpdaterId, ((object)(value)));
			}
		}
		[UmlElement(Id="520542c2-fa97-451b-93d5-f1a0c247a5e7", Index=Eco_LoopbackIndices.OldSalary)]
		public double OldSalary
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OldSalary)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.OldSalary, ((object)(value)));
			}
		}
		[UmlElement(Id="98b7c6e6-bda9-4d2d-9f5c-5b42a8425367", Index=Eco_LoopbackIndices.PercentChange)]
		public double PercentChange
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.PercentChange)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.PercentChange, ((object)(value)));
			}
		}
		[UmlElement(Id="8fa6e0c8-5660-4ecc-a7f4-9e461d30faf5", Index=Eco_LoopbackIndices.NewSalary)]
		public double NewSalary
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.NewSalary)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.NewSalary, ((object)(value)));
			}
		}
    }

	[UmlCollection(typeof(SalaryHistory))]
	public interface ISalaryHistoryList : ICollection
	{
		#region ECO generated code
		SalaryHistory this[int index]
		{
			get;
			set;
		}
		int Add(SalaryHistory value);
		bool Contains(SalaryHistory value);
		int IndexOf(SalaryHistory value);
		void Insert(int index, SalaryHistory value);
		void Remove(SalaryHistory value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(ProjectDepartmentBudget))]
	public interface IProjectDepartmentBudgetList : ICollection
	{
		#region ECO generated code
		ProjectDepartmentBudget this[int index]
		{
			get;
			set;
		}
		int Add(ProjectDepartmentBudget value);
		bool Contains(ProjectDepartmentBudget value);
		int IndexOf(ProjectDepartmentBudget value);
		void Insert(int index, ProjectDepartmentBudget value);
		void Remove(ProjectDepartmentBudget value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
}
